<?php
// ১. এডমিন লগইন প্রোটেকশন (User: admin, Pass: 123456)
if (!isset($_SERVER['PHP_AUTH_USER']) || $_SERVER['PHP_AUTH_USER'] !== 'admin' || $_SERVER['PHP_AUTH_PW'] !== '123456') {
    header('WWW-Authenticate: Basic realm="VIP Admin Panel"');
    header('HTTP/1.0 401 Unauthorized');
    die("Unauthorized Access!");
}

include 'db_config.php';

// ২. মার্কেট সেটআপ (Pair & Time) আপডেট
if (isset($_POST['update_market'])) {
    $asset = mysqli_real_escape_string($conn, $_POST['asset']);
    $time = mysqli_real_escape_string($conn, $_POST['expiry_time']);
    mysqli_query($conn, "UPDATE signals SET asset='$asset', expiry_time='$time', direction='NONE' WHERE id=1");
    echo "<script>alert('Market Updated!'); window.location='admin.php';</script>";
}

// ৩. সিগন্যাল ডিরেকশন আপডেট (UP/DOWN/NONE)
if (isset($_GET['action'])) {
    $dir = $_GET['action'];
    mysqli_query($conn, "UPDATE signals SET direction='$dir' WHERE id=1");
    header("Location: admin.php");
}

// ৪. ইউজার একশন (Approve, Block, Unblock, Delete)
if (isset($_GET['user_action']) && isset($_GET['uid'])) {
    $uid = (int)$_GET['uid'];
    $act = $_GET['user_action'];

    if ($act == 'approve') {
        mysqli_query($conn, "UPDATE users SET status='active' WHERE id=$uid");
    } elseif ($act == 'block') {
        mysqli_query($conn, "UPDATE users SET is_blocked=1 WHERE id=$uid");
    } elseif ($act == 'unblock') {
        mysqli_query($conn, "UPDATE users SET is_blocked=0 WHERE id=$uid");
    } elseif ($act == 'delete') {
        mysqli_query($conn, "DELETE FROM users WHERE id=$uid");
    }
    header("Location: admin.php");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VIP Trading Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body { background: #f0f2f5; font-family: 'Poppins', sans-serif; }
        .card { border: none; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        .btn-signal { height: 70px; font-size: 22px; font-weight: bold; border-radius: 10px; }
        .screenshot-img { width: 60px; height: 60px; object-fit: cover; border-radius: 8px; cursor: pointer; border: 1px solid #ddd; }
        .status-badge { padding: 5px 10px; border-radius: 50px; font-size: 12px; font-weight: 600; }
        .table-container { background: #fff; padding: 20px; border-radius: 15px; }
    </style>
</head>
<body>

<nav class="navbar navbar-dark bg-dark mb-4">
    <div class="container">
        <a class="navbar-brand fw-bold" href="#">👑 VIP SIGNAL ADMIN</a>
        <span class="text-light">Welcome, Admin</span>
    </div>
</nav>

<div class="container">
    <div class="row g-4">
        
        <!-- মার্কেট সেটআপ এবং সিগন্যাল কন্ট্রোল -->
        <div class="col-lg-4">
            <div class="card p-4 mb-4">
                <h5 class="fw-bold mb-3 text-primary">⚙️ Step 1: Market Setup</h5>
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label small">Pair Name</label>
                        <input type="text" name="asset" class="form-control" placeholder="EUR/USD (OTC)" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label small">Expiry Time</label>
                        <select name="expiry_time" class="form-select">
                            <option value="1 MIN">1 MIN</option>
                            <option value="2 MIN">2 MIN</option>
                            <option value="5 MIN">5 MIN</option>
                        </select>
                    </div>
                    <button name="update_market" class="btn btn-primary w-100 fw-bold">SET MARKET</button>
                </form>
            </div>

            <div class="card p-4">
                <h5 class="fw-bold mb-3 text-success">🚀 Step 2: Live Signal</h5>
                <div class="row g-2">
                    <div class="col-6">
                        <a href="?action=UP" class="btn btn-success w-100 btn-signal d-flex align-items-center justify-content-center">UP</a>
                    </div>
                    <div class="col-6">
                        <a href="?action=DOWN" class="btn btn-danger w-100 btn-signal d-flex align-items-center justify-content-center">DOWN</a>
                    </div>
                    <div class="col-12 mt-2">
                        <a href="?action=NONE" class="btn btn-secondary w-100 py-3 fw-bold">WAITING / NONE</a>
                    </div>
                </div>
                <?php 
                    $curr = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM signals WHERE id=1"));
                ?>
                <div class="mt-3 p-2 bg-light rounded text-center small border">
                    <b>Active:</b> <?php echo $curr['asset']; ?> (<?php echo $curr['expiry_time']; ?>) | <b>Signal:</b> <?php echo $curr['direction']; ?>
                </div>
            </div>
        </div>

        <!-- ইউজার ম্যানেজমেন্ট টেবিল -->
        <div class="col-lg-8">
            <div class="table-container shadow-sm">
                <h5 class="fw-bold mb-4">👥 User Requests & Management</h5>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>User Info</th>
                                <th>Payment Details</th>
                                <th>Shot</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $users = mysqli_query($conn, "SELECT * FROM users ORDER BY id DESC");
                            if(mysqli_num_rows($users) > 0) {
                                while($row = mysqli_fetch_assoc($users)) {
                                    // স্ট্যাটাস লজিক
                                    $is_blocked = (isset($row['is_blocked']) && $row['is_blocked'] == 1);
                            ?>
                            <tr>
                                <td>
                                    <div class="fw-bold"><?php echo $row['gmail']; ?></div>
                                    <small class="text-muted">QID: <?php echo $row['quotex_id']; ?></small>
                                </td>
                                <td>
                                    <div class="small"><b>Method:</b> <?php echo $row['payment_method']; ?></div>
                                    <div class="small"><b>TXID:</b> <?php echo $row['txid']; ?></div>
                                    <div class="small"><b>Pkg:</b> <?php echo $row['package_days']; ?> Days</div>
                                </td>
                                <td>
                                    <a href="uploads/<?php echo $row['screenshot']; ?>" target="_blank">
                                        <img src="uploads/<?php echo $row['screenshot']; ?>" class="screenshot-img">
                                    </a>
                                </td>
                                <td>
                                    <?php if($is_blocked): ?>
                                        <span class="status-badge bg-danger text-white">BLOCKED</span>
                                    <?php elseif($row['status'] == 'active'): ?>
                                        <span class="status-badge bg-success text-white">ACTIVE</span>
                                    <?php else: ?>
                                        <span class="status-badge bg-warning text-dark">PENDING</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-dark dropdown-toggle" data-bs-toggle="dropdown">Manage</button>
                                        <ul class="dropdown-menu">
                                            <?php if($row['status'] == 'pending'): ?>
                                                <li><a class="dropdown-item text-primary fw-bold" href="?user_action=approve&uid=<?php echo $row['id']; ?>">Approve User</a></li>
                                            <?php endif; ?>

                                            <?php if(!$is_blocked): ?>
                                                <li><a class="dropdown-item text-warning" href="?user_action=block&uid=<?php echo $row['id']; ?>">Block User</a></li>
                                            <?php else: ?>
                                                <li><a class="dropdown-item text-info" href="?user_action=unblock&uid=<?php echo $row['id']; ?>">Unblock User</a></li>
                                            <?php endif; ?>
                                            
                                            <li><hr class="dropdown-divider"></li>
                                            <li><a class="dropdown-item text-danger" href="?user_action=delete&uid=<?php echo $row['id']; ?>" onclick="return confirm('Delete this user permanently?')">Delete Permanently</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            <?php 
                                } 
                            } else {
                                echo "<tr><td colspan='5' class='text-center py-4'>No users found.</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>