<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BotMatrix</title>

    <!-- ফ্যাব আইকন এখানে বসান -->
     <link rel="icon" type="image/png" href="favicon.png">
    <link rel="apple-touch-icon" href="favicon.png">


    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;900&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-glow: #00b8ff;
            --vip-gold: #ffb800;
            --text-main: #ffffff;
            --text-dim: #a8b2d1;
        }

        body {
            margin: 0;
            padding: 0;
            background: radial-gradient(circle at top right, #1a1f2c, #06070a);
            background-attachment: fixed;
            color: var(--text-main);
            font-family: 'Poppins', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow-x: hidden;
        }

        /* গ্রিড ব্যাকগ্রাউন্ড */
        body::before {
            content: "";
            position: absolute;
            top: 0; left: 0; width: 100%; height: 100%;
            background-image: 
                linear-gradient(rgba(0, 184, 255, 0.03) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 184, 255, 0.03) 1px, transparent 1px);
            background-size: 40px 40px;
            z-index: -1;
        }

        .reg-card {
            background: rgba(18, 21, 28, 0.9);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 30px;
            padding: 40px;
            width: 100%;
            max-width: 520px;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.8);
            margin: 40px 20px;
            text-align: center;
        }

        /* লোগো সেটিংস */
        .brand-logo {
            width: 250px; /* লোগোর সাইজ এখান থেকে পরিবর্তন করতে পারবেন */
            height: auto;
            margin-bottom: 5px;
            filter: drop-shadow(0 0 10px rgba(30, 255, 0, 0.66));
        }

        .subtitle {
            color: var(--text-dim);
            font-size: 11px;
            letter-spacing: 1px;
            text-transform: uppercase;
            margin-bottom: 30px;
            display: block;
        }

        /* টেক্সট ভিজিবিলিটি ফিক্স */
        label { 
            color: #ffffff !important; 
            font-size: 13px; 
            margin-bottom: 8px; 
            font-weight: 600;
            display: block;
            text-align: left;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-control, .form-select {
            background: rgba(0, 0, 0, 0.5) !important;
            border: 1px solid #333945 !important;
            color: #ffffff !important;
            border-radius: 12px;
            padding: 12px 15px;
            font-size: 14px;
        }
        
        .form-control::placeholder { color: #555c71; }
        .form-control:focus {
            border-color: var(--primary-glow) !important;
            box-shadow: 0 0 10px rgba(0, 184, 255, 0.2);
        }

        /* পেমেন্ট বক্স */
        .payment-info {
            background: rgba(255, 184, 0, 0.03);
            border: 1px solid var(--vip-gold);
            border-radius: 20px;
            padding: 20px;
            margin-top: 20px;
            display: none;
            animation: slideIn 0.4s ease-out;
        }
        @keyframes slideIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }

        .qr-img {
            width: 160px; height: 160px;
            margin: 10px auto;
            border-radius: 15px;
            border: 3px solid #fff;
            display: block;
        }

        /* কপি সেকশন */
        .copy-container {
            background: #000;
            padding: 12px;
            border-radius: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid #2a2e39;
            margin-top: 15px;
        }
        .address-text { font-size: 12px; color: var(--vip-gold); word-break: break-all; font-weight: 600; }
        .btn-copy {
            background: var(--vip-gold);
            color: #000; font-weight: bold; border: none;
            padding: 6px 15px; border-radius: 8px; font-size: 11px;
            cursor: pointer; transition: 0.2s;
        }
        .btn-copy:hover { transform: scale(1.05); background: #ffa500; }

        .btn-submit {
            background: linear-gradient(45deg, var(--vip-gold), #ff8a00);
            color: #000; font-weight: 800;
            padding: 16px; border-radius: 15px; border: none;
            width: 100%; margin-top: 25px;
            text-transform: uppercase; letter-spacing: 1px;
            transition: 0.3s;
        }
        .btn-submit:hover { transform: translateY(-3px); box-shadow: 0 10px 25px rgba(255, 184, 0, 0.4); }

        a.login-link { color: var(--vip-gold); text-decoration: none; font-weight: 600; }
        a.login-link:hover { text-decoration: underline; }


        
    * {
        -webkit-user-select: none !important;
        -moz-user-select: none !important;
        -ms-user-select: none !important;
        user-select: none !important;
        -webkit-user-drag: none !important;
    }
    input, textarea {
        -webkit-user-select: text !important;
        -moz-user-select: text !important;
        user-select: text !important;
    }

    </style>
</head>
<body oncontextmenu="return false" onselectstart="return false" ondragstart="return false">

    <div class="reg-card">
        <!-- আপনার লোগো এখানে সেট করা হয়েছে -->
        <img src="logo.png" class="brand-logo" alt="AlgoVibe Logo"><br></br>
        

        <form action="process_reg.php" method="POST" enctype="multipart/form-data">
            
            <div class="mb-3">
                <label>GMAIL ADDRESS</label>
                <input type="email" name="gmail" class="form-control" placeholder="example@gmail.com" required>
            </div>

            <div class="mb-3">
                <label>QUOTEX ID</label>
                <input type="text" name="quotex_id" class="form-control" placeholder="Ex: 5623841" required>
            </div>

           


            <button type="submit" name="register" class="btn btn-submit">Submit Application</button>
        </form>

        <div class="mt-4">
            <span style="color: var(--text-dim); font-size: 13px;">Already have access?</span> 
            <a href="login.php" class="login-link small">LOGIN HERE</a>
        </div>
    </div>

    <script>
        function updatePaymentInfo() {
            const method = document.getElementById('payMethod').value;
            const box = document.getElementById('paymentBox');
            const title = document.getElementById('methodTitle');
            const qr = document.getElementById('qrImg');
            const addr = document.getElementById('addrDisplay');

            if(!method) { box.style.display = "none"; return; }
            
            box.style.display = "block";
            
            if(method === "USDT_TRC20") {
                title.innerText = "USDT (TRC20)";
                qr.src = "qrcodes/trc20.png";
                addr.innerText = "TWizgtWgHasj6n5CdznDdTaKfDMEGEWn7w";
            } else if(method === "USDT_BEP20") {
                title.innerText = "USDT (BEP20)";
                qr.src = "qrcodes/bep20.png";
                addr.innerText = "0xbef7b265b10e2c1c3f85ac880db3693cb9205e1b";
            } else if(method === "BKASH") {
                title.innerText = "bKash Personal";
                qr.src = "qrcodes/bkash.png";
                addr.innerText = "017XXXXXXXX";
            }
        }

        function copyContent() {
            const text = document.getElementById('addrDisplay').innerText;
            navigator.clipboard.writeText(text).then(() => {
                alert("Address Copied!");
            });
        }
    </script>

<script type="text/javascript">
    // ১. মাউস রাইট ক্লিক সম্পূর্ণ বন্ধ (একদম রুট লেভেলে)
    document.oncontextmenu = function() { return false; };

    // ২. টেক্সট সিলেকশন এবং ড্র্যাগিং বন্ধ করা
    document.onselectstart = function() { return false; };
    document.ondragstart = function() { return false; };

    // ৩. কিবোর্ড শর্টকাট প্রোটেকশন (F12, Ctrl+U, Ctrl+I ইত্যাদি)
    document.addEventListener("keydown", function(e) {
        // F12 key
        if (e.keyCode == 123) {
            e.preventDefault();
            return false;
        }
        // Ctrl+Shift+I (Inspect)
        if (e.ctrlKey && e.shiftKey && e.keyCode == 73) {
            e.preventDefault();
            return false;
        }
        // Ctrl+Shift+J (Console)
        if (e.ctrlKey && e.shiftKey && e.keyCode == 74) {
            e.preventDefault();
            return false;
        }
        // Ctrl+U (View Source)
        if (e.ctrlKey && e.keyCode == 85) {
            e.preventDefault();
            return false;
        }
        // Ctrl+S (Save)
        if (e.ctrlKey && e.keyCode == 83) {
            e.preventDefault();
            return false;
        }
    }, false);

    // ৪. কেউ যদি জোর করে কনসোল ওপেন করে তবে ডাটা ক্লিয়ার করে দেওয়া
    setInterval(function(){
        console.clear();
    }, 500);
</script>


</body>
</html>