<?php 
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if(!isset($_SESSION['user'])) {
    header("Location: /");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BotMatrix</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@900&family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --bg-dark: #06070a;
            --vip-gold: #ffb800;
            --gold-gradient: linear-gradient(135deg, #ffb800 0%, #fff7ad 50%, #ffb800 100%);
            --metallic-bg: #12151c;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body { 
            background: radial-gradient(circle at center, #1a2332, var(--bg-dark));
            background-attachment: fixed;
            color: #ffffff; 
            font-family: 'Poppins', sans-serif; 
            display: flex; justify-content: center; align-items: center; 
            height: 100vh; overflow: hidden;
        }

        /* প্রফেশনাল গ্রিড ব্যাকগ্রাউন্ড */
        body::before {
            content: ""; position: absolute; top: 0; left: 0; width: 100%; height: 100%;
            background-image: linear-gradient(rgba(0, 184, 255, 0.03) 1px, transparent 1px), linear-gradient(90deg, rgba(0, 184, 255, 0.03) 1px, transparent 1px);
            background-size: 45px 45px; z-index: -1;
        }

        /* অডিও স্টার্ট ওভারলে */
        #audio-starter {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%; 
            background: rgba(0,0,0,0.95); z-index: 9999; 
            display: flex; justify-content: center; align-items: center; cursor: pointer;
        }
        .start-btn {
            background: var(--vip-gold); color: #000; padding: 18px 45px; 
            border-radius: 50px; font-weight: 900; font-size: 18px; 
            box-shadow: 0 0 30px rgba(255, 184, 0, 0.5); text-transform: uppercase;
        }

        /* কার্ড ফিক্স: কোনাগুলো নিখুঁত করার জন্য নতুন মেথড */
        .premium-case {
            width: 380px;
            padding: 45px 30px;
            border-radius: 45px; /* কার্ডের রাউন্ড কোনা */
            position: relative;
            text-align: center;
            background: var(--metallic-bg);
            box-shadow: 0 40px 80px rgba(0,0,0,0.8);
            
            /* গোল্ডেন বর্ডার ফিক্স (কোনা বের হবে না) */
            border: 4px solid transparent;
            background-image: linear-gradient(var(--metallic-bg), var(--metallic-bg)), var(--gold-gradient);
            background-origin: border-box;
            background-clip: padding-box, border-box;
        }

        .brand-logo { width: 180px; margin-bottom: 20px; filter: drop-shadow(0 0 10px rgba(0,0,0,0.5)); }
        .asset-name { font-family: 'Montserrat', sans-serif; font-size: 34px; color: var(--vip-gold); text-transform: uppercase; font-weight: 900; letter-spacing: 1px; }
        .time-badge { display: inline-block; background: rgba(0,0,0,0.4); padding: 6px 20px; border-radius: 8px; font-size: 13px; color: #aaa; margin-top: 8px; margin-bottom: 35px; border: 1px solid #333; }

        /* মেটালিক স্লট উইন্ডো */
        .slot-window {
            height: 135px;
            background: linear-gradient(to bottom, #b8860b 0%, #f7e08b 20%, #ffffff 50%, #f7e08b 80%, #b8860b 100%);
            border-radius: 15px;
            overflow: hidden;
            position: relative;
            border: 6px solid #000;
            box-shadow: inset 0 0 25px rgba(0,0,0,0.7);
        }

        .reel {
            display: flex;
            flex-direction: column;
            transition: transform 1.2s cubic-bezier(0.45, 0.05, 0.55, 0.95);
        }

        .slot-item {
            height: 135px;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: 'Montserrat', sans-serif;
            font-size: 65px;
            font-weight: 900;
            text-transform: uppercase;
            letter-spacing: 3px;
        }

        .item-up { color: #008f11; text-shadow: 2px 2px 0px rgba(255,255,255,0.4); }
        .item-down { color: #d40000; text-shadow: 2px 2px 0px rgba(255,255,255,0.4); }
        .item-wait { color: #222; opacity: 0.6; }

        .spinning { animation: fast-spin 0.15s linear infinite; }
        @keyframes fast-spin {
            0% { transform: translateY(0); }
            100% { transform: translateY(-405px); } /* 135 * 3 */
        }

        .footer-tag { margin-top: 25px; font-size: 11px; color: #444; font-weight: bold; letter-spacing: 1px; text-transform: uppercase; }

    </style>
</head>
<body>

    <div id="audio-starter">
        <div class="start-btn">Activate VIP Signals 🔔</div>
    </div>

    <!-- প্রিমিয়াম কেস -->
    <div class="premium-case">
        <img src="logo.png" class="brand-logo" alt="AlgoVibe Logo">
        
        <div id="asset-name" class="asset-name">EUR/USD</div>
        <div id="expiry-time" class="time-badge">TIME: 1 MIN</div>

        <!-- মেটালিক স্লট উইন্ডো -->
        <div class="slot-window">
            <div id="reel" class="reel">
                <div class="slot-item item-wait">WAIT</div>
                <div class="slot-item item-up">CALL</div>
                <div class="slot-item item-down">PUT</div>
                <div class="slot-item item-wait">WAIT</div>
            </div>
        </div>

        
    </div>

    <audio id="beep" preload="auto">
        <source src="https://assets.mixkit.co/active_storage/sfx/2869/2869-preview.mp3" type="audio/mpeg">
    </audio>

    <script>
        let lastSignal = "";
        let audioEnabled = false;
        const sound = document.getElementById('beep');
        const starter = document.getElementById('audio-starter');
        const reel = document.getElementById('reel');

        starter.addEventListener('click', () => {
            sound.play().then(() => {
                sound.pause(); sound.currentTime = 0;
                audioEnabled = true;
                starter.style.display = 'none';
            });
        });

        function fetchSignal() {
            fetch('fetch_signal.php')
            .then(res => res.json())
            .then(data => {
                if(data.direction === 'BLOCKED') { window.location.href = "/"; return; }

                document.getElementById('asset-name').innerText = data.asset;
                document.getElementById('expiry-time').innerText = "TIME: " + data.expiry_time;

                if(data.direction !== lastSignal) {
                    reel.classList.add('spinning');
                    
                    setTimeout(() => {
                        reel.classList.remove('spinning');
                        if(data.direction === "UP") {
                            reel.style.transform = "translateY(-135px)";
                            if(audioEnabled) sound.play();
                        } else if(data.direction === "DOWN") {
                            reel.style.transform = "translateY(-270px)";
                            if(audioEnabled) sound.play();
                        } else {
                            reel.style.transform = "translateY(0px)";
                        }
                    }, 1200);
                    lastSignal = data.direction;
                }
            });
        }

        setInterval(fetchSignal, 1000);
        fetchSignal();
    </script>
</body>
</html>